// By EVOLVED
// www.evolved-software.com

//--------------
// tweaks
//--------------
   float2 ViewSize;
   float AdaptedMin=0.1;
   float AdaptedMax=1.0;

//--------------
// Textures
//--------------
   texture RenderTexture <string Name = " ";>;
   sampler RenderSampler=sampler_state 
      {
	Texture=<RenderTexture>;
      };
   texture DepthTexture <string Name = " ";>;
   sampler DepthSampler=sampler_state 
      {
	Texture=<DepthTexture>;
   	ADDRESSU=CLAMP;
   	ADDRESSV=CLAMP;
   	ADDRESSW=CLAMP;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION;
     };
   struct OutPut
     {
	float4 Pos:POSITION; 
 	float4 Tex:TEXCOORD0;
	float4 Tex1:TEXCOORD1;
	float4 Tex2:TEXCOORD2;
	float4 Tex3:TEXCOORD3;
	float4 Tex4:TEXCOORD4;
	float4 Tex5:TEXCOORD5;
	float4 Tex6:TEXCOORD6;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     {
 	OutPut OUT;
	OUT.Pos=IN.Pos; 
  	OUT.Tex.xy=((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5)+ViewSize;
	OUT.Tex.zw=(OUT.Tex.xy+0.5)*0.5;
	OUT.Tex1.xy=OUT.Tex.zw+float2(-ViewSize.x,0)*4.0;
	OUT.Tex1.zw=OUT.Tex.zw+float2(ViewSize.x,0)*4.0;
	OUT.Tex2.xy=OUT.Tex.zw+float2(0,-ViewSize.y)*4.0;
	OUT.Tex2.zw=OUT.Tex.zw+float2(0,ViewSize.y)*4.0;
	OUT.Tex3.xy=OUT.Tex.zw+float2(-ViewSize.x,-ViewSize.y)*4.0;
	OUT.Tex3.zw=OUT.Tex.zw+float2(ViewSize.x,ViewSize.y)*4.0;
	OUT.Tex4.xy=OUT.Tex.zw+float2(ViewSize.x,-ViewSize.y)*4.0;
	OUT.Tex4.zw=OUT.Tex.zw+float2(-ViewSize.x,ViewSize.y)*4.0;
	OUT.Tex5.xy=((OUT.Tex.xy+4.5)*0.1)+0.04;
	OUT.Tex5.zw=((OUT.Tex.xy+4.5)*0.1)-0.04;
	OUT.Tex6.xy=((OUT.Tex.xy+4.5)*0.1)+float2(-0.04,0.04);
	OUT.Tex6.zw=((OUT.Tex.xy+4.5)*0.1)+float2(0.04,-0.04);
	return OUT;
    }

//--------------
// pixel shader
//--------------
  float4 PS(OutPut IN) : COLOR
     {
	float3 LuminanceSum=tex2Dlod(RenderSampler,IN.Tex)
	                   +tex2Dlod(RenderSampler,IN.Tex1.xyyy)
	                   +tex2Dlod(RenderSampler,IN.Tex1.zwww)
	                   +tex2Dlod(RenderSampler,IN.Tex2.xyyy)
	                   +tex2Dlod(RenderSampler,IN.Tex2.zwww)
	                   +tex2Dlod(RenderSampler,IN.Tex3.xyyy)
	                   +tex2Dlod(RenderSampler,IN.Tex3.zwww)
	                   +tex2Dlod(RenderSampler,IN.Tex4.xyyy)
	                   +tex2Dlod(RenderSampler,IN.Tex4.zwww);
	float Depth=max(max(1/tex2Dlod(DepthSampler,IN.Tex5.xyyy).x,1/tex2Dlod(DepthSampler,IN.Tex5.zwww).x),
			max(1/tex2Dlod(DepthSampler,IN.Tex6.xyyy).x,1/tex2Dlod(DepthSampler,IN.Tex6.zwww).x));
	return float4(log(clamp(dot(LuminanceSum.xyz*0.111111,float3(0.299,0.587,0.114)),AdaptedMin,AdaptedMax)),log(Depth),0,0);
     }

//--------------
// techniques   
//--------------
    technique Luminance
      {
 	pass p1
      {	
 	VertexShader = compile vs_3_0 VS();
 	PixelShader  = compile ps_3_0 PS();
	zwriteenable=false;
	zenable=false;
	ZFunc=always;
      }
      }
